<?php
/**
 * @author Arthur Schiwon <blizzz@arthur-schiwon.de>
 * @author Joas Schilling <coding@schilljs.com>
 * @author Morris Jobke <hey@morrisjobke.de>
 *
 * @copyright Copyright (c) 2016, ownCloud GmbH.
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

namespace OCA\User_LDAP;

/**
 * @brief wraps around static ownCloud core methods
 */
class FilesystemHelper {

	/**
	 * @brief states whether the filesystem was loaded
	 * @return bool
	 */
	public function isLoaded() {
		return \OC\Files\Filesystem::$loaded;
	}

	/**
	 * @brief initializes the filesystem for the given user
	 * @param string $uid the ownCloud username of the user
	 */
	public function setup($uid) {
		\OC_Util::setupFS($uid);
	}
}
