/*
 * Decompiled with CFR 0.152.
 */
package gota;

import gota.Monitor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GOFFile
implements Runnable {
    private Monitor owner;
    private String url;
    private HashMap<String, String> fileProperties;
    private String filename;
    private File localFile;
    private long lastModified;
    private boolean busy;
    private Process process;
    private Thread monitorProcess;

    public GOFFile(String url) {
        this.url = url;
        this.fileProperties = new HashMap();
    }

    public GOFFile(String url, HashMap<String, String> properties) {
        this.url = url;
        this.fileProperties = properties;
    }

    public String get(String key) {
        return this.fileProperties.get(key);
    }

    public void put(String key, String value) {
        this.fileProperties.put(key, value);
    }

    public void readProperties(String filename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            File gofFile = new File(filename);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(gofFile);
            Element root = doc.getDocumentElement();
            NodeList elements = root.getChildNodes();
            for (int s = 0; s < elements.getLength(); ++s) {
                Node element = elements.item(s);
                if (element.getNodeType() != 1) continue;
                String property = element.getNodeName();
                NodeList textList = element.getChildNodes();
                Node valueNode = textList.item(0);
                String value = "";
                if (valueNode != null) {
                    value = valueNode.getNodeValue();
                    value = value.trim();
                }
                this.fileProperties.put(property, value);
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.url);
        sb.append("\nlast modified: " + this.lastModified);
        for (String next : this.fileProperties.keySet()) {
            sb.append("\n");
            sb.append(next);
            sb.append(": ");
            sb.append(this.fileProperties.get(next));
        }
        return sb.toString();
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
        Date dt = new Date();
        this.lastModified = dt.getTime() + 3000L;
    }

    public long lastModified() {
        return this.localFile.lastModified();
    }

    public boolean isModified() {
        return this.lastModified() > this.lastModified;
    }

    public void updateModified() {
        this.lastModified = this.lastModified();
        this.fileProperties.put("last_modified", String.valueOf(this.getLocalFile().lastModified()));
    }

    public String getName() {
        return this.localFile.getName();
    }

    public String getPath() {
        return this.localFile.getPath();
    }

    public String getCanonicalPath() throws IOException {
        return this.localFile.getCanonicalPath();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = this.convertToLowerAscii(filename);
    }

    private String convertToLowerAscii(String str) {
        char[] chars = str.toCharArray();
        boolean germanScharfesS = false;
        boolean aeFound = false;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] < '\u0080') continue;
            if (chars[i] >= '\u00c0' && chars[i] <= '\u00c5' || chars[i] >= '\u00e0' && chars[i] <= '\u00e5') {
                chars[i] = 97;
                continue;
            }
            if (chars[i] == '\u00c6' || chars[i] == '\u00e6') {
                aeFound = true;
                continue;
            }
            if (chars[i] == '\u00c7' || chars[i] == '\u00e7') {
                chars[i] = 99;
                continue;
            }
            if (chars[i] >= '\u00c8' && chars[i] <= '\u00cb' || chars[i] >= '\u00e8' && chars[i] <= '\u00eb') {
                chars[i] = 101;
                continue;
            }
            if (chars[i] >= '\u00cc' && chars[i] <= '\u00cf' || chars[i] >= '\u00ec' && chars[i] <= '\u00ef') {
                chars[i] = 105;
                continue;
            }
            if (chars[i] == '\u00d0' || chars[i] == '\u00f0') {
                chars[i] = 100;
                continue;
            }
            if (chars[i] == '\u00d1' || chars[i] == '\u00f1') {
                chars[i] = 110;
                continue;
            }
            if (chars[i] >= '\u00d2' && chars[i] <= '\u00d6' || chars[i] >= '\u00f2' && chars[i] <= '\u00f6' || chars[i] == '\u00d8' || chars[i] == '\u00f8') {
                chars[i] = 111;
                continue;
            }
            if (chars[i] >= '\u00d9' && chars[i] <= '\u00dc' || chars[i] >= '\u00f9' && chars[i] <= '\u00fc') {
                chars[i] = 117;
                continue;
            }
            if (chars[i] == '\u00dd' || chars[i] == '\u00fd' || chars[i] == '\u00ff') {
                chars[i] = 121;
                continue;
            }
            if (chars[i] == '\u00de' || chars[i] == '\u00fe') {
                chars[i] = 98;
                continue;
            }
            if (chars[i] != '\u00df') continue;
            germanScharfesS = true;
        }
        String ret = new String(chars);
        if (germanScharfesS) {
            ret = ret.replace("\u00df", "ss");
        }
        if (aeFound) {
            ret = ret.replace("\u00e6", "ae");
            ret = ret.replace("\u00c6", "ae");
        }
        return ret;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void startMonitorProcess() {
        this.monitorProcess = new Thread(this);
        this.monitorProcess.start();
    }

    @Override
    public void run() {
        try {
            this.process.waitFor();
            this.owner.removeFile(this.getUrl());
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public String isMonitorProcess() {
        try {
            int v = this.process.exitValue();
            return String.valueOf(v);
        }
        catch (IllegalThreadStateException ex) {
            return "true";
        }
    }

    public Monitor getOwner() {
        return this.owner;
    }

    public void setOwner(Monitor owner) {
        this.owner = owner;
    }
}

