GO.billing.CustomerReportGrid = function(config){
	
	if(!config)
	{
		config = {};
	}
	
	config.layout='fit';
	config.autoScroll=true;
	config.split=true;
	config.store = new GO.data.JsonStore({
	    url: GO.url('billing/report/customer'),
	    baseParams: {
	    	
	    	},
	    root: 'results',
	    id: 'customer_name',
	    totalProperty:'total',
	    fields: ['customer_name', 'turnover'],
	    remoteSort: true
	});
	
	
	var columnModel =  new Ext.grid.ColumnModel({
		defaults:{
			sortable:true
		},
		columns:[
		{
			header: GO.lang.strName,
			dataIndex: 'customer_name'
		},{
			header: GO.billing.lang.turnover, 
			dataIndex: 'turnover'
		}
	]
	});
	
	config.cm=columnModel;
	
	config.view=new Ext.grid.GridView({
		autoFill: true,
		forceFit: true,
		emptyText: GO.lang['strNoItems']
	}),
	config.sm=new Ext.grid.RowSelectionModel();
	config.loadMask=true;
	
	GO.billing.CustomerReportGrid.superclass.constructor.call(this, config);
	
};

Ext.extend(GO.billing.CustomerReportGrid, GO.grid.GridPanel,{

});